#pragma once

#ifndef SERVICESPC_H
#define SERVICESPC_H

#include "Service.h"
#include "SpeechCall.h"
#include "OutGoingSpeechCall.h"
#include "IncomingSpeechCall.h"
////////////////////////////////////////////////////////////////////////////////

/****************************************************************/
/* Supplementary service notification intermediate result codes */
/****************************************************************/
#define kUnconditionalCallForwardingActive				0 
#define kSomeConditionalCallForwardingsActive			1
#define kCallHasBeenForwarded							2
#define kCallIsWaiting									3
#define kCallCUGIntermediate							4//<index> present
#define kOutgoingCallsAreBarred							5
#define kIncomingCallsAreBarred							6
#define kCLIRsuppressionRejected						7
#define kCallHasBeenDeflected							8

/***************************************************************/
/* Supplementary service notification unsolicited result codes */
/***************************************************************/
#define kForwardedCall									0
#define kCallCUGunsolicited								1//<index> present
#define kCallPutOnHold									2//during a voice call
#define kCallRetrieved									3//during a voice call
#define kMultipartyCallEntered							4//during a voice call
#define kCallOnHoldReleased								5//during a voice call
#define kForwardCheckSSmessageReceived					6//can be received whenever
#define kCallAlerting									7//In explicit call transfer operation during a voice call
#define kConnected										8//In explicit call transfer operation (also number and subaddress parameters may be present) (during a voice call or MT call setup)
#define kDeflectedCall									9//MT call setup
///////////////////////////////////////////////////////////////////////////////////

#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport) 
#endif
///////////////////////////////////////////////////////////////////////////////////

class CSpeechCall;
///////////////////////////////////////////////////////////////////////////////////

class DLLMANAGER_API CServiceSPC :	public CService
{
private:	
	int				mOpenedLines;
	CSpeechCall*	mLines[kMaxOpenedLines];
	int				mMaxLine;
	CObArray		mLineArray;
public:
	CServiceSPC(void);
	CServiceSPC(CDllManager* iDllManager);
	virtual ~CServiceSPC(void);
private:
	int PrvOCallBarred(CString iNum);
	int PrvICallBarred(CString iNum);
	// test if incoming call allowed
	int PrvICallAllowed();
public:
	virtual CObArray*	 GetOpenedLine();
	virtual int			 GetOpenedLineNumber();
	virtual	CSpeechCall* GetLine(int iLineID);
	virtual int			 GetLineIndex(int iLineID);
	virtual int			 GetLineIndex(ELineState iEState);
	virtual int			 GetFirstFreeIndex();
	virtual bool		 GetOperationPossible(ESpcOperation iEPoss, int iLineID);
	virtual void		 FormatCSSU(int iCode);
	virtual void		 FormatCSSI(int iCode);
	// vib
	virtual void		Vib();
	// CServiceSTY message handlers
	virtual Bool Dispatch(CCmd* iCmdP);
	virtual void OnConfigChange(int iConfigID);	
	virtual void OnConfigChange(int iConfigID, int iConfigEvent);

	virtual bool MEBusy();
	virtual void RemoveLine(int iLineIndex);
	virtual void RemoveLines(ELineState iState);

	virtual void HoldAllActiveLine();
	virtual void AlertLine(int iLineID);
	virtual void ConnectLine(int iLineID);
	virtual void ErrorLine(int iLineID);
	virtual void ReleaseLine(int iLineID);
	virtual void BusyLine(int iLineID);
	virtual void ForwardCall(int iLindeID);

	// used by CHLD
	virtual int ReleaseHeldWaiting();
	virtual int ReleaseActiveAcceptHeldWait();
	int			HoldActiveCalls(int iLineID);
	int			PermuteHeldWaitingActiveLines();
	int			MergeHeld();
	int			GetActiveCallNumber();
	int			GetCallNumber();

	virtual int NewIncomingCall(Bool iIsForwardedCall, CString iCallerID, CString iCallerName, int iSilentMode=0);

	virtual CSpeechCall* CreateIncomingSpeechCall(Bool iIsForwardedCall, CString iCallerID, CString iCallerName, int iLineID, Bool iCallWaiting, CConfigSPC* iCfgSPC);
	virtual CSpeechCall* CreateOutgoingSpeechCall(CString iNumber, int iLineID, bool iCSSIenable, CConfigSPC* iCfgSPC);

	virtual Bool A(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool D(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool D2(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool H(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CLIP(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool COLP(CCmd* iCmdP, Bool iSilentMode=0);	
	virtual Bool CLIR(CCmd* iCmdP, Bool iSilentMode=0);	
	// CCFC functions
	virtual Bool CCFC(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CCFCDisable(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CCFCEnable(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CCFCQuery(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CCFCRegistration(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CCFCErasure(CCmd* iCmdP, Bool iSilentMode=0);	

	//
	virtual Bool CBST(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CCWA(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CSSN(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CRC(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CHLD(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CLCC(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CUSD(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CTFR(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CPAS(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool VTS(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CSTA(CCmd* iCmdP, Bool iSilentMode=0);
};
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
#endif
